/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.init;

import com.ferreusveritas.dynamictrees.DynamicTrees;
import com.ferreusveritas.dynamictrees.api.registry.AbstractRegistry;
import com.ferreusveritas.dynamictrees.api.registry.Registries;
import com.ferreusveritas.dynamictrees.api.registry.Registry;
import com.ferreusveritas.dynamictrees.api.registry.RegistryEvent;
import com.ferreusveritas.dynamictrees.api.registry.SimpleRegistry;
import com.ferreusveritas.dynamictrees.api.registry.TypeRegistryEvent;
import com.ferreusveritas.dynamictrees.api.worldgen.FeatureCanceller;
import com.ferreusveritas.dynamictrees.block.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.block.leaves.PalmLeavesProperties;
import com.ferreusveritas.dynamictrees.block.leaves.ScruffyLeavesProperties;
import com.ferreusveritas.dynamictrees.block.leaves.SolidLeavesProperties;
import com.ferreusveritas.dynamictrees.block.leaves.WartProperties;
import com.ferreusveritas.dynamictrees.block.rooty.AerialRootsSoilProperties;
import com.ferreusveritas.dynamictrees.block.rooty.SoilProperties;
import com.ferreusveritas.dynamictrees.block.rooty.SpreadableSoilProperties;
import com.ferreusveritas.dynamictrees.block.rooty.WaterSoilProperties;
import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialisers;
import com.ferreusveritas.dynamictrees.resources.Resources;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import com.ferreusveritas.dynamictrees.tree.family.MangroveFamily;
import com.ferreusveritas.dynamictrees.tree.family.NetherFungusFamily;
import com.ferreusveritas.dynamictrees.tree.family.PalmFamily;
import com.ferreusveritas.dynamictrees.tree.species.FakeMushroomSpecies;
import com.ferreusveritas.dynamictrees.tree.species.MangroveSpecies;
import com.ferreusveritas.dynamictrees.tree.species.NetherFungusSpecies;
import com.ferreusveritas.dynamictrees.tree.species.PalmSpecies;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.tree.species.SwampOakSpecies;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegisterEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DTTrees {
    public static final ResourceLocation NULL = DynamicTrees.location("null");
    public static final ResourceLocation OAK = DynamicTrees.location("oak");
    public static final ResourceLocation BIRCH = DynamicTrees.location("birch");
    public static final ResourceLocation SPRUCE = DynamicTrees.location("spruce");
    public static final ResourceLocation JUNGLE = DynamicTrees.location("jungle");
    public static final ResourceLocation DARK_OAK = DynamicTrees.location("dark_oak");
    public static final ResourceLocation ACACIA = DynamicTrees.location("acacia");
    public static final ResourceLocation AZALEA = DynamicTrees.location("azalea");
    public static final ResourceLocation CRIMSON = DynamicTrees.location("crimson");
    public static final ResourceLocation WARPED = DynamicTrees.location("warped");

    @SubscribeEvent
    public static void registerSpecies(RegistryEvent<Species> event) {
        event.getRegistry().registerAll(new Species[]{new FakeMushroomSpecies(true), new FakeMushroomSpecies(false)});
    }

    @SubscribeEvent
    public static void registerSoilProperties(RegistryEvent<SoilProperties> event) {
        event.getRegistry().registerAll(new SoilProperties[0]);
    }

    @SubscribeEvent
    public static void registerLeavesPropertiesTypes(TypeRegistryEvent<LeavesProperties> event) {
        event.registerType(DynamicTrees.location("solid"), SolidLeavesProperties.TYPE);
        event.registerType(DynamicTrees.location("wart"), WartProperties.TYPE);
        event.registerType(DynamicTrees.location("palm"), PalmLeavesProperties.TYPE);
        event.registerType(DynamicTrees.location("scruffy"), ScruffyLeavesProperties.TYPE);
    }

    @SubscribeEvent
    public static void registerFamilyTypes(TypeRegistryEvent<Family> event) {
        event.registerType(DynamicTrees.location("nether_fungus"), NetherFungusFamily.TYPE);
        event.registerType(DynamicTrees.location("mangrove"), MangroveFamily.TYPE);
        event.registerType(DynamicTrees.location("palm"), PalmFamily.TYPE);
    }

    @SubscribeEvent
    public static void registerSpeciesTypes(TypeRegistryEvent<Species> event) {
        event.registerType(DynamicTrees.location("nether_fungus"), NetherFungusSpecies.TYPE);
        event.registerType(DynamicTrees.location("swamp_oak"), SwampOakSpecies.TYPE);
        event.registerType(DynamicTrees.location("palm"), PalmSpecies.TYPE);
        event.registerType(DynamicTrees.location("mangrove"), MangroveSpecies.TYPE);
    }

    @SubscribeEvent
    public static void registerSoilPropertiesTypes(TypeRegistryEvent<SoilProperties> event) {
        event.registerType(DynamicTrees.location("water"), WaterSoilProperties.TYPE);
        event.registerType(DynamicTrees.location("spreadable"), SpreadableSoilProperties.TYPE);
        event.registerType(DynamicTrees.location("aerial_roots"), AerialRootsSoilProperties.TYPE);
    }

    @SubscribeEvent
    public static void newRegistry(NewRegistryEvent event) {
        List<SimpleRegistry> registries = Registries.REGISTRIES.stream().filter(registry -> registry instanceof SimpleRegistry).map(registry -> (SimpleRegistry)registry).collect(Collectors.toList());
        registries.forEach(AbstractRegistry::postRegistryEvent);
        Resources.setupTreesResourceManager();
        JsonDeserialisers.registerForgeEntryGetters();
        JsonDeserialisers.postRegistryEvent();
        FeatureCanceller.REGISTRY.postRegistryEvent();
        FeatureCanceller.REGISTRY.lock();
    }

    @SubscribeEvent
    public static void loadResources(RegisterEvent event) {
        if (event.getRegistryKey() != ForgeRegistries.BLOCKS.getRegistryKey()) {
            return;
        }
        Resources.MANAGER.load();
        Registries.REGISTRIES.stream().filter(registry -> registry instanceof SimpleRegistry).forEach(Registry::lock);
    }
}

